<?php

namespace Mtc\RecentlyViewed;

use Illuminate\Support\ServiceProvider;

class RecentlyViewedProvider extends ServiceProvider
{
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__) . '/config/recently_viewed.php', 'recently_viewed');
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/migrations');
        $this->app->bind(RecentlyViewedRepository::class, function () {
            return new RecentlyViewedRepository(config('recently_viewed'));
        });

        $this->app->bind('recently-viewed', RecentlyViewedRepository::class);
    }

    public function boot()
    {
        if ($this->app->runningInConsole()) {
            $this->publishes([
                __DIR__ . '/config/recently_viewed.php' => $this->app->configPath(),
            ], 'config');
        }
    }
}
