<?php

namespace Mtc\RecentlyViewed;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Mtc\RecentlyViewed\Models\RecentlyViewedModel;

class RecentlyViewedRepository
{
    public function __construct(protected array $config)
    {
        //
    }

    public function track(Model $viewer, Model $viewed, string $category): void
    {
        $model = RecentlyViewedModel::query()
            ->firstOrCreate([
                'viewer_id' => $viewer->id,
                'viewer_type' => $viewer->getMorphClass(),
                'category' => $category,
                'viewed_id' => $viewed->id,
                'viewed_type' => $viewed->getMorphClass(),
            ]);

        if ($model->wasRecentlyCreated === false) {
            $model->touch();
        }

        $this->dropOldViewed($viewer, $category);
    }

    public function get(Model $viewer, string $category = null, int $count = null): Collection
    {
        return RecentlyViewedModel::query()
            ->with('viewed')
            ->where('viewer_id', $viewer->id)
            ->where('viewer_type', $viewer->getMorphClass())
            ->when($category, fn($query) => $query->where('category', $category))
            ->when($count, fn($query) => $query->take($count))
            ->latest('updated_at')
            ->get()
            ->map(fn (RecentlyViewedModel $view) => $view->viewed);
    }

    protected function dropOldViewed(Model $viewer, string $category): void
    {
        RecentlyViewedModel::query()
            ->where('viewer_id', $viewer->id)
            ->where('viewer_type', $viewer->getMorphClass())
            ->where('category', $category)
            ->latest('updated_at')
            ->skip($this->config['history_per_category'])
            ->take(3)
            ->get()
            ->each(fn(RecentlyViewedModel $viewed_item) => $viewed_item->delete());
    }
}
