<?php

namespace Mtc\Refunds;

use Illuminate\Database\Eloquent\Model;
use Mtc\Checkout\Invoice;

/**
 * Class Refund
 *
 * @package Mtc\Refunds
 */
class Refund extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'invoice_refunds';

    /**
     * Mass assignable attributes
     *
     * @var array
     */
    protected $fillable = [
        'invoice_id',
        'payment_id',
        'amount',
        'reference',
        'details',
    ];

    /**
     * Cast attributes to types
     *
     * @var array
     */
    protected $casts = [
        'details' => 'array'
    ];

    /**
     * Relationship with invoice
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }

    /**
     * Relationship with payment
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function payment()
    {
        return $this->belongsTo(Invoice\Payment::class);
    }
}
