<?php

namespace Mtc\ContentManager\Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\Reports\Models\Report;
use Mtc\Reports\Tests\AsUser;
use Mtc\Reports\Tests\TestCase;

class ReportControllerTest extends TestCase
{
    use RefreshDatabase;
    use AsUser;

    public function testIndex()
    {
        $this->asUser();

        Report::factory(5)->create();
        $response = $this->getJson(route('reports.index'));

        $response->assertStatus(200);
        $this->assertArrayHasKey('data', $response->json());
        $this->assertEquals(5, $response->json('total'));
    }

    public function testStore()
    {
        $this->asUser();

        $response = $this->postJson(route('reports.store'), [
            'name' => 'lorem ipsum',
            'type' => 'users',
        ]);
        $response->assertStatus(201);
        $this->assertTrue(Report::query()->where('name', 'lorem ipsum')->exists());
    }

    public function testShow()
    {
        $this->asUser();

        $report = Report::factory()->create();
        $response = $this->getJson(route('reports.show', $report));

        $response->assertStatus(200);
        $this->assertEquals($report->id, $response->json('id'));
    }

    public function testUpdate()
    {
        $this->asUser();

        $report = Report::factory()->create();
        $response = $this->putJson(route('reports.update', $report->id), [
            'name' => 'Lorem ipsum',
            'type' => 'users',
            'format' => 'csv',
            'schedule' => 'daily',
            'active' => 1,
        ]);

        $response->assertStatus(200);
        $report->refresh();
        $this->assertEquals('Lorem ipsum', $report->name);
        $this->assertEquals('users', $report->type);
        $this->assertEquals('csv', $report->format);
        $this->assertEquals('daily', $report->schedule);
        $this->assertTrue($report->active);
    }

    public function testDestroy()
    {
        $this->asUser();

        $report = Report::factory()->create();
        $response = $this->deleteJson(route('reports.destroy', $report));

        $response->assertStatus(200);
        $this->assertFalse(Report::query()->where('id', $report->id)->exists());
    }

}
