<?php

namespace Mtc\Reports\Providers;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Route;
use Mtc\Reports\Console\Commands\RunReporting;
use Mtc\Reports\Contracts\ReportLogModel;
use Mtc\Reports\Contracts\ReportModel;
use Mtc\Reports\ReportRepository;

class ReportProvider extends RouteServiceProvider
{
    /**
     * Register the provider
     *
     * @return void
     */
    public function register(): void
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/reports.php', 'reports');

        parent::register();
        if (config('reports.auto_load_migrations')) {
            $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations/');
        }

        // Model Bindings
        $this->app->bind(ReportModel::class, Config::get('reports.report_model'));
        $this->app->bind(ReportLogModel::class, Config::get('reports.log_model'));
    }

    /**
     * Boot the provider
     *
     * @throws BindingResolutionException
     * @return void
     */
    public function boot(): void
    {
        $this->publishes([
            dirname(__DIR__, 2) . '/database/migrations' => $this->app->databasePath('migrations'),
        ], 'migrations');

        $this->loadViewsFrom(dirname(__DIR__, 2) . '/resources/views', 'reports');

        // Repositories
        $this->app->bind(ReportRepository::class, Config::get('reports.repository'));
        $this->app->bind('report_repository', Config::get('reports.repository'));

        $this->commandsAndSchedule();
    }

    /**
     * Define the "web" routes
     *
     * These routes all receive session state, CSRF protection, etc.
     *
     * @return void
     */
    public function map(): void
    {
        if (config('reports.load_routes') !== true) {
            return;
        }

        Route::prefix('api')
            ->middleware('api')
            ->group(dirname(__DIR__, 2) . '/routes/api.php');
    }
    /**
     * Register commands and schedule tasks
     *
     * @return void
     */
    public function commandsAndSchedule(): void
    {
        $this->commands([
            RunReporting::class,
        ]);

        if (config('reports.schedule_tasks')) {
            $this->app->booted(function () {
                $schedule = $this->app->make(Schedule::class);
                $schedule->command(RunReporting::class)->hourly();
            });
        }
    }
}
