<?php

namespace Mtc\Reports\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\Reports\Models\Report;

class ReportFactory extends Factory
{
    protected $model = Report::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name' => $this->faker->name(),
            'type' => $this->faker->word(),
            'active' => random_int(0, 1),
            'schedule' => random_int(0, 1) ? 'daily' : 'weekly',
            'format' => random_int(0, 1) ? 'email' : 'csv',
            'recipient' => $this->faker->safeEmail(),
            'columns' => [],
            'conditions' => [],
            'last_report_sent_at' => random_int(0, 1) ? Carbon::now()->subDays(random_int(0, 40)) : null,
            'next_report_due_at' => random_int(0, 1) ? Carbon::now()->addDays(random_int(0, 7)) : null,
        ];
    }
}
