<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\Reports\Models\ReportLog;
use Mtc\Reports\Models\Report;
use Tests\TestCase;

class ReportLogModelTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    /**
     * Test that the MAX_ROWS limit is enforced and the oldest records are deleted.
     *
     * @return void
     */
    public function test_max_rows_limit()
    {
        // Step 1: Create reports and use the first report's ID for logs
        $reports = Report::factory(5)->create();
        $reportId = $reports->first()->id;

        // Step 2: Insert 30 rows into the report_logs table using the first report's ID
        foreach (range(1, 30) as $i) {
            ReportLog::create([
                'created_at' => now(),
                'updated_at' => now(),
                'report_id' => $reportId,
                'succeeded' => rand(0, 1),
            ]);
        }

        // Step 3: Verify that the report has 30 log records
        $this->assertCount(30, ReportLog::where('report_id', $reportId)->get());

        // Step 4: Insert the 31st row and trigger the logic
        ReportLog::create([
            'created_at' => now(),
            'updated_at' => now(),
            'report_id' => $reportId,
            'succeeded' => rand(0, 1),
        ]);

        // Step 5: Verify that there are only 30 rows now
        $this->assertCount(30, ReportLog::where('report_id', $reportId)->get());

        // Step 6: Verify the oldest row was deleted (by checking the creation time)
        $oldestRow = ReportLog::orderBy('created_at', 'asc')->first();
        $this->assertNotNull($oldestRow);
        $this->assertTrue($oldestRow->created_at->lt(now()));

        // Ensure the `report_id` is still consistent with the first report's ID
        $this->assertEquals($reportId, $oldestRow->report_id);
    }
}
