<?php

namespace Mtc\ContentManager\Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Mail\Mailable;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;
use Mtc\Reports\Console\Commands\RunReporting;
use Mtc\Reports\Facades\Reports;
use Mtc\Reports\Mail\ReportMail;
use Mtc\Reports\Models\Report;
use Mtc\Reports\Tests\AsUser;
use Mtc\Reports\Tests\TestCase;
use Mtc\Reports\Tests\User;

class RunReportTest extends TestCase
{
    use RefreshDatabase;

    public function testSelectsCorrectReportsToRun()
    {
        Report::factory(3)->create([
            'next_report_due_at' => Carbon::now()->addDay(),
            'active' => 1,
        ]);
        $this->assertTrue(Reports::getDueReports()->isEmpty());

        Report::factory(3)->create([
            'next_report_due_at' => Carbon::now()->subDay(),
            'active' => 1,
        ]);
        $this->assertCount(3, Reports::getDueReports());

        Report::factory(3)->create([
            'next_report_due_at' => Carbon::now()->addDay(),
            'active' => 0,
        ]);
        $this->assertCount(3, Reports::getDueReports());
    }

    public function testRunReportingCommand()
    {
        User::query()->create([
            'name' => 'peter',
            'email' => 'test@example.com',
            'password' => '',
        ]);

        $report = Report::factory()->create([
            'name' => 'foo',
            'type' => 'users',
            'schedule' => 'daily',
            'format' => 'csv',
            'active' => 1,
            'next_report_due_at' => Carbon::now(),
            'columns' => ['name', 'email'],
            'conditions' => [],
            'recipient' => 'foo@baz.bar',
        ]);

        Storage::fake();
        Mail::fake();
        $this->artisan(RunReporting::class);

        Mail::assertQueued(ReportMail::class, function (Mailable $mailable) {
            return $mailable->hasTo('foo@baz.bar');
        });
        $this->assertTrue($report->logs()->exists());
    }

}
