<?php

namespace Mtc\Returns\Filters;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Mtc\Foundation\Contracts\AdminFilter;

/**
 * Class FilterByCode
 *
 * @package Mtc\Returns
 */
class FilterByStatus implements AdminFilter
{
    /**
     * Constant for input field name
     */
    const INPUT_FIELD_NAME = 'status';

    /**
     * Field definition
     *
     * @return mixed
     */
    public function field()
    {
        return [
            'type' => 'select',
            'name' => self::INPUT_FIELD_NAME,
            'label' => 'Status',
            'default_option_label' => 'All',
            'values' => [
                config('returns.statuses.requested') => __('returns::returns.statuses.requested'),
                config('returns.statuses.pending') =>  __('returns::returns.statuses.pending'),
                config('returns.statuses.processed') => __('returns::returns.statuses.processed'),
                config('returns.statuses.requires_info') => __('returns::returns.statuses.requires_info'),
                config('returns.statuses.cancelled') => __('returns::returns.statuses.cancelled'),
                config('returns.statuses.finalized') => __('returns::returns.statuses.finalized'),
            ],
            'value' => \request(self::INPUT_FIELD_NAME),
        ];
    }

    /**
     * Handle the filtering of a field
     *
     * @param Request $request
     * @param Builder $query
     * @return Builder
     */
    public function handle(Request $request, Builder $query): Builder
    {
        if (empty($request->input(self::INPUT_FIELD_NAME))) {
            return $query;
        }

        return $query->where('status_id', $request->input(self::INPUT_FIELD_NAME));
    }
}
