<?php

namespace Mtc\Returns\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Mtc\Returns\Rules\EmailMatchesOrderReference;
use Mtc\Orders\Rules\ValidOrderReference;
use Mtc\Returns\Rules\ReturnRequestIsNotPastExpiry;

/**
 * Class ValidReturnRequestSearch
 *
 * @package App\Http\Requests
 */
class ReturnSearchRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'email' => [
                'required',
                'email',
                new EmailMatchesOrderReference($this->request->get('reference'))
            ],
            'reference' => [
                'required',
                new ValidOrderReference(),
                new ReturnRequestIsNotPastExpiry(),
            ],
        ];
    }
}
