<?php

namespace Mtc\Returns\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\Foundation\Country;
use Mtc\Foundation\Http\Resources\CountryList;
use Mtc\Returns\ReturnItem;
use Mtc\Returns\ReturnReason;

/**
 * Class ReturnRequestResponse
 *
 * @package Mtc\Returns
 */
class ReturnRequestResponse extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $countries = Country::query()
            ->with('states')
            ->where('status', 1)
            ->get();

        $this->resource->setVisible([
            'id',
            'reference',
            'returnable_items',
        ]);

        $this->resource->returnable_items = $this->resource->items
            ->filter()
            ->map(function ($order_item) {
                $quantity_returned = ReturnItem::query()
                    ->wherehas('returnRequest', function ($return_query) {
                        return $return_query->where('status_id', config('returns.statuses.processed'));
                    })
                    ->where('order_item_id', $order_item->id)
                    ->sum('approved_quantity');
                return [
                    'order_item_id' => $order_item->id,
                    'name' => $order_item->name,
                    'attribute_fields' => $order_item->attribute_fields,
                    'price' => $order_item->paid_price->raw($this->resource->use_ex_vat),
                    'requested_quantity' => max(0, $order_item->quantity - $quantity_returned),
                    'request_type' => '',
                    'reason' => '',
                ];
            });

        $reasons = ReturnReason::query()
            ->public()
            ->get()
            ->groupBy(function ($reason) {
                return ucfirst($reason->type);
            });
        return [
            'reasons' => $reasons,
            'order' => $this->resource,
            'countries' => new CountryList($countries),
        ];
    }
}
