<?php

namespace Mtc\Returns\Scopes;

use Illuminate\Database\Eloquent\Scope;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

/**
 * Class ExcludesDraft
 *
 * Make sure draft returns are ignored when running a query
 *
 * @package Mtc\Returns\Scopes
 */
class ExcludesDraft implements Scope
{
    /**
     * Apply the scope to a given Eloquent query builder.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @param  \Illuminate\Database\Eloquent\Model  $model
     * @return void
     */
    public function apply(Builder $builder, Model $model)
    {
        $builder->where('status_id', '!=', config('returns.statuses.draft'));
    }
}
