<?php

return [

    'enabled' => true,

    /*
    |--------------------------------------------------------------------------
    | Service Providers
    |--------------------------------------------------------------------------
    |
    | Attach additional service providers for providing routing and event injection
    | Routing
    |
    */

    'service_providers' => [
        \Mtc\Returns\Providers\ReturnRouteServiceProvider::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Event Listeners
    |--------------------------------------------------------------------------
    |
    | Manage events and their listeners here.
    |
    */

    'events' => [
        Mtc\Orders\Events\FetchOrderProcessingActions::class => [
            \Mtc\Returns\Listeners\AddReturnToOrderActions::class,
        ],
        \Mtc\Returns\Events\NewReturn::class => [
            \Mtc\Returns\Listeners\NewReturnEmail::class,
        ],
        \Mtc\Returns\Events\ReturnProcessed::class => [
            \Mtc\Returns\Listeners\ReturnProcessedEmail::class,
            \Mtc\Returns\Listeners\ReallocateStockDirectly::class
        ],
        \Mtc\Returns\Events\ReturnCancelled::class => [
            \Mtc\Returns\Listeners\ReturnCancelledEmail::class,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Expiry of applicable orders
    |--------------------------------------------------------------------------
    |
    | Define the amount of days that returns are allowed for order.
    | Requests with orders older than the given amount of days will be prevented
    | from creating a return request.
    |
    | 0 for no limit
    |
    */

    'expiry_days' => 30,

    /*
    |--------------------------------------------------------------------------
    | Statuses
    |--------------------------------------------------------------------------
    |
    | Status values -system uses verbose transitions in code.
    |
    */

    'statuses' => [
        'draft' => 0,
        'requested' => 1,
        'pending' => 2,
        'processed' => 3,
        'requires_info' => 4,
        'cancelled' => 5,
    ],

    'status_badges' => [
        'draft' => 'badge-light',
        'requested' => 'badge-primary',
        'pending' => 'badge-secondary',
        'processed' => 'badge-success',
        'requires_info' => 'badge-warning',
        'cancelled' => 'badge-dark',
    ],

    /*
    |--------------------------------------------------------------------------
    | Admin search filters
    |--------------------------------------------------------------------------
    |
    | Classes that will implement search filters on order admin list page
    | Each class is expected to follow the format of AdminFilter interface
    |
    */

    'admin_search_filters' => [
        \Mtc\Returns\Filters\FilterByReference::class,
        \Mtc\Returns\Filters\FilterByEmail::class,
        \Mtc\Returns\Filters\FilterByStatus::class,
    ]
];
