<?php

namespace Mtc\Returns;

use Illuminate\Database\Eloquent\Model;

/**
 * Class ExchangeItem
 *
 * @package Mtc\Returns
 */
class ExchangeItem extends Model
{
    /**
     * Mass assignable attributes
     *
     * @var array
     */
    protected $fillable = [
        'return_item_id',
        'purchasable_id',
        'purchasable_type',
        'quantity'
    ];

    /**
     * Return Item
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function returnItem()
    {
        return $this->belongsTo(ReturnItem::class);
    }

    /**
     * Relationship with purchasable (item/size)
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function purchasable()
    {
        return $this->morphTo();
    }
}
