<?php

namespace Mtc\Returns\Listeners;

use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;

/**
 * Class AddReturnToOrderActions
 *
 * @package Mtc\Returns\Listeners
 */
class AddReturnToOrderActions
{
    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return array
     */
    public function handle($event)
    {
        return [
            'name' => 'Create a Return Request',
            'action' => route('admin.returns.store', [ 'order_id' => $event->getOrder()->id ]),
            'method' => 'post'
        ];
    }
}
