<?php

namespace Mtc\Returns\Listeners;

use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Mtc\Returns\Events\NewReturn;

/**
 * Class NewReturnEmail
 *
 * @package Mtc\Returns\Listeners
 */
class NewReturnEmail
{

    /**
     * Handle the event.
     *
     * @param  NewReturn $event
     * @return void
     */
    public function handle(NewReturn $event)
    {
        $subject = __('returns::returns.return_created_email_subject');
        $content = template('emails/returns/new_request.twig', [
            'return' => $event->return,
        ]);

        email(SHOP_EMAIL, $subject, $content);
    }
}
