<?php

namespace Mtc\Returns\Rules;

use Illuminate\Contracts\Validation\Rule;
use Mtc\Returns\ReturnItem;

/**
 * Class ApplicableOrderItemReturnQuantity
 *
 * @package Mtc\Returns\Rules
 */
class ApplicableOrderItemReturnQuantity implements Rule
{
    /**
     * @var int
     */
    protected $return_id;

    /**
     * ApplicableOrderItemReturnQuantity constructor.
     *
     * @param $return_id
     */
    public function __construct($return_id)
    {
        $this->return_id = $return_id;
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param string $attribute
     * @param mixed $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        $return_item_id = end(explode('.', $attribute));
        $return_item = ReturnItem::query()->find($return_item_id);
        $already_returned = $this->alreadyReturnedItemCount($return_item);

        return $value <= $return_item->orderItem->quantity - $already_returned;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'The quantity set for item exceeds allowed amount.';
    }

    /**
     * Find the quantity of the already approved return stock for this item
     *
     * @param $return_item
     * @return mixed
     */
    protected function alreadyReturnedItemCount($return_item)
    {
        return ReturnItem::query()
            ->whereHas('returnRequest', function ($request_query) {
                $request_query->where('status_id', config('returns.statuses.processed'));
            })
            ->where('return_id', '!=', $this->return_id)
            ->where('order_item_id', $return_item->order_item_id)
            ->sum('approved_quantity');
    }
}
