<?php

namespace Mtc\Returns\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\App;
use Mtc\Orders\Contracts\OrderContract;

/**
 * Class EmailMatchesOrderReference
 *
 * @package Mtc\Orders
 */
class EmailMatchesOrderReference implements Rule
{
    /**
     * @var string
     */
    protected $order_reference;

    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct($order_reference)
    {
        $this->order_reference = $order_reference;
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return App::make(OrderContract::class)
            ->newQuery()
            ->where('email', $value)
            ->where('reference', $this->order_reference)
            ->exists();
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'Order with these details was not found.';
    }
}
