<?php

namespace Mtc\Returns\Seeds;

use Illuminate\Database\Seeder;
use Mtc\Returns\ReturnReason;

/**
 * Class SeedReturnReasons
 *
 * Seed default return reasons
 *
 * @package Mtc\Returns
 */
class SeedReturnReasons extends Seeder
{
    /**
     * Run the seeder
     */
    public function run()
    {
        collect($this->getData())
            ->each(function ($entry) {
                ReturnReason::query()->create($entry);
            });
    }

    /**
     * Get data to seed
     * 
     * @return array
     */
    protected function getData()
    {
        return [

            [
                'name' => 'Picking Error',
                'type' => 'exchange',
                'reallocate_stock' => 1,
                'admin_only' => 1
            ],
            [
                'name' => 'Picking Error Return',
                'type' => 'refund',
                'reallocate_stock' => 1,
                'admin_only' => 1
            ],
            [
                'name' => 'Missing Delivery',
                'type' => 'exchange',
                'reallocate_stock' => 0,
                'admin_only' => 1
            ],
            [
                'name' => 'Too big',
                'type' => 'exchange',
                'reallocate_stock' => 1,
                'admin_only' => 0
            ],
            [
                'name' => 'Colour not as expected',
                'type' => 'exchange',
                'reallocate_stock' => 1,
                'admin_only' => 0
            ],
            [
                'name' => 'Other',
                'type' => 'refund',
                'reallocate_stock' => 1,
                'admin_only' => 0
            ],
            [
                'name' => 'Did not like fit',
                'type' => 'exchange',
                'reallocate_stock' => 1,
                'admin_only' => 0
            ],
            [
                'name' => 'No Stock',
                'type' => 'exchange',
                'reallocate_stock' => 0,
                'admin_only' => 1
            ],
            [
                'name' => 'Other',
                'type' => 'exchange',
                'reallocate_stock' => 1,
                'admin_only' => 0
            ],
            [
                'name' => 'Did not like fit',
                'type' => 'refund',
                'reallocate_stock' => 1,
                'admin_only' => 0
            ],
            [
                'name' => 'Too small',
                'type' => 'exchange',
                'reallocate_stock' => 1,
                'admin_only' => 0
            ],
            [
                'name' => 'Faulty',
                'type' => 'exchange',
                'reallocate_stock' => 0,
                'admin_only' => 0
            ],
            [
                'name' => 'Faulty',
                'type' => 'refund',
                'reallocate_stock' => 0, 
                'admin_only' => 0
            ],
            [
                'name' => 'Incorrect item',
                'type' => 'exchange',
                'reallocate_stock' => 1,
                'admin_only' => 0
            ],
            [
                'name' => 'Missing Delivery',
                'type' => 'refund', 
                'reallocate_stock' => 0,
                'admin_only' => 1
            ],
            [
                'name' => 'Too Big',
                'type' => 'refund', 
                'reallocate_stock' => 1, 
                'admin_only' => 0
            ],
            [
                'name' => 'Colour not as expected',
                'type' => 'refund', 
                'reallocate_stock' => 1,
                'admin_only' => 0
            ],
            [
                'name' => 'No Stock',
                'type' => 'refund',
                'reallocate_stock' => 0, 
                'admin_only' => 1
            ],
            [
                'name' => 'Incorrect item',
                'type' => 'refund', 
                'reallocate_stock' => 1, 
                'admin_only' => 0
            ],
            [
                'name' => 'Too Small',
                'type' => 'refund',
                'reallocate_stock' => 1,
                'admin_only' => 0
            ],
        ];
    }
}