<?php

namespace Mtc\Returns\Http\Presenters;

use Illuminate\Contracts\Support\Arrayable;
use Mtc\Orders\OrderShipmentBox;
use Mtc\Returns\ReturnRequest;

/**
 * Class ReturnRequestUrlPresenter
 *
 * @package Mtc\Returns
 */
class ReturnRequestUrlPresenter implements Arrayable
{

    /**
     * @var ReturnRequest
     */
    protected $request;

    /**
     * OrderShipmentBoxUrlPresenter constructor.
     *
     * @param OrderShipmentBox $box
     */
    public function __construct(ReturnRequest $request)
    {
        $this->request = $request;
    }

    /**
     * Accessor
     *
     * @param $key
     * @return mixed
     */
    public function __get($key)
    {
        if(method_exists($this, $key)) {
            return $this->$key();
        }

        return $this->$key;
    }

    /**
     * Add support for conversion to array
     *
     * @return array
     */
    public function toArray()
    {
        return [
            'edit' => $this->edit(),
            'update' => $this->update(),
            'destroy' => $this->destroy()
        ];
    }

    /**
     * Store route
     *
     * @return string
     */
    public function edit()
    {
        return route('admin.returns.edit', [ $this->request->id ]);
    }

    /**
     * Update route
     *
     * @return string
     */
    public function update()
    {
        return route('admin.returns.update', [ $this->request->id ]);
    }

    /**
     * Destroy route
     *
     * @return string
     */
    public function destroy()
    {
        return route('admin.returns.destroy', [ $this->request->id ]);
    }


}
