<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateReturnTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('returns', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('status_id')->default(0)->index();
            $table->unsignedInteger('order_id')->index();
            $table->string('reference')->index();
            $table->text('message')->nullable();
            $table->decimal('delivery_refund_amount', 10)->nullable();
            $table->boolean('locked')->default(0);
            $table->timestamps();
        });

        Schema::create('return_items', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->morphs('purchasable');
            $table->unsignedInteger('return_id')->index();
            $table->unsignedInteger('order_item_id')->index();
            $table->unsignedInteger('reason_id')->index();
            $table->integer('requested_quantity')->default(0);
            $table->integer('approved_quantity')->default(0);
            $table->timestamps();
        });

        Schema::create('exchange_items', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('return_item_id')->index();
            $table->morphs('purchasable');
            $table->integer('quantity');
            $table->timestamps();
        });

        Schema::create('return_reasons', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('type')->index();
            $table->string('code', 50)->nullable();
            $table->string('name');
            $table->boolean('reallocate_stock')->default(0);
            $table->boolean('admin_only')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('returns');
        Schema::dropIfExists('return_items');
        Schema::dropIfExists('exchange_items');
        Schema::dropIfExists('return_reasons');
    }
}
