<?php

namespace Mtc\Returns\Listeners;

use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Mtc\Returns\Events\ReturnProcessed;
use Mtc\Returns\ReturnItem;
use Mtc\Shop\Order\Item;

/**
 * Class ReallocateStockDirectly
 *
 * @package App\Listeners
 */
class ReallocateStockDirectly
{
    /**
     * Return object
     *
     * @var \Mtc\Returns\ReturnRequest
     */
    protected $return;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct(ReturnProcessed $event)
    {
        $this->return = $event->return;
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle($event)
    {
        $this->return->items
            ->each(function (ReturnItem $return_item) {
                $return_item->orderItem->purchasable->increment('stock', $return_item->approved_quantity);
            });
    }
}
