<?php

use Illuminate\Routing\Router;
use Mtc\Returns\Http\Controllers\ReturnController;
use Mtc\Returns\Http\Controllers\Admin\AdminReturnController;
use Mtc\Returns\Http\Controllers\MemberReturnController;
/** @var Router $router */

$router->get('/members/returns', [MemberReturnController::class, 'index'])->name('my_returns');
$router->get('/members/returns/{request}', [MemberReturnController::class, 'show'])->name('view_return');
$router->post('/returns/find', [ReturnController::class, 'find']);
$router->get('/returns/{order_id?}', [ReturnController::class, 'index'])->name('returns.index');
$router->post('/returns', [ReturnController::class, 'store']);

$router->group([
    'prefix' => '/admin',
    'as' => 'admin.',
    'middleware' => 'auth'
], function (Router $router) {
    $router->put('/returns/{return_request}/set-status', [AdminReturnController::class, 'updateStatus'])->name('returns.update-status');
    $router->resource('/returns', AdminReturnController::class);
});
