<?php

namespace Mtc\Returns\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Mtc\Returns\ReturnRequest;

/**
 * Class ReturnProcessed
 *
 * @package Mtc\Returns\Events
 */
class ReturnProcessed
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * @var ReturnRequest
     */
    public $return;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(ReturnRequest $return)
    {
        $this->return = $return;
    }
}
