<?php

namespace Mtc\Returns\Filters;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Mtc\Foundation\Contracts\AdminFilter;

/**
 * Class FilterByReference
 *
 * @package Mtc\Returns
 */
class FilterByEmail implements AdminFilter
{
    /**
     * Constant for input field name
     */
    public const INPUT_FIELD_NAME = 'email';

    /**
     * Field definition
     *
     * @return mixed
     */
    public function field()
    {
        return [
            'type' => 'text',
            'name' => self::INPUT_FIELD_NAME,
            'label' => 'Email',
            'value' => \request(self::INPUT_FIELD_NAME),
        ];
    }

    /**
     * Handle the filtering of a field
     *
     * @param Request $request
     * @param Builder $query
     * @return Builder
     */
    public function handle(Request $request, Builder $query): Builder
    {
        if (empty($request->input(self::INPUT_FIELD_NAME))) {
            return $query;
        }

        return $query->whereHas('order', function ($query) use ($request) {
            return $query->where('email', $request->input(self::INPUT_FIELD_NAME));
        });
    }
}
