<?php

namespace Mtc\Returns\Listeners;

use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Mtc\Returns\Events\ReturnProcessed;

/**
 * Class ReturnProcessedEmail
 *
 * @package Mtc\Returns\Listeners
 */
class ReturnProcessedEmail
{
    /**
     * Handle the event.
     *
     * @param  ReturnProcessed $event
     * @return void
     */
    public function handle(ReturnProcessed $event)
    {
        $subject = __('returns::returns.return_processed_email_subject');
        $content = template('emails/returns/return_processed.twig', [
            'return' => $event->return,
        ]);

        email($event->return->order->email, $subject, $content);
    }
}
