<?php
    namespace Mtcmedia\RevolutPaymentProvider\Controllers;

    use Illuminate\Http\Request;
    use Mtcmedia\RevolutPaymentProvider\Services\RevolutService;

    class RevolutController
    {
        protected $revolutService;

        public function __construct(RevolutService $revolutService)
        {
            $this->revolutService = $revolutService;
        }

        public function test()
        {
            return template('revolut/form.twig');
        }


        public function createPayment(Request $request)
        {
            $payment = $this->revolutService->createPayment([
                'amount' => $request->amount,
                'currency' => $request->currency,
                'description' => $request->description,
                'metadata' => $request->metadata,
            ]);

            return response()->json($payment);
        }

        public function handleWebhook(Request $request)
        {
            $signature = $request->header('Revolut-Signature');

            // Verify webhook signature
            if (!$this->verifyWebhookSignature($request->getContent(), $signature)) {
                return response()->json(['error' => 'Invalid signature'], 400);
            }

            $event = $request->all();

            // Handle different event types
            switch ($event['type']) {
                case 'payment.completed':
                    // Handle successful payment
                    break;
                case 'payment.failed':
                    // Handle failed payment
                    break;
            }

            return response()->json(['status' => 'success']);
        }

        protected function verifyWebhookSignature(string $payload, string $signature)
        {
            $expectedSignature = hash_hmac(
                'sha256',
                $payload,
                config('revolut.webhook_secret')
            );

            return hash_equals($expectedSignature, $signature);
        }
    }
