<?php
    namespace Mtcmedia\RevolutPaymentProvider\Support;

    use GuzzleHttp\Client;
    use GuzzleHttp\Exception\GuzzleException;

    class RevolutClient
    {
        protected $client;
        protected $baseUrl;

        public function __construct(string $apiKey, string $environment)
        {
            $this->baseUrl = $environment === 'production'
                ? 'https://api.revolut.com'
                : 'https://sandbox.revolut.com';

            $this->client = new Client([
                'base_uri' => $this->baseUrl,
                'headers' => [
                    'Authorization' => "Bearer {$apiKey}",
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json',
                ],
            ]);
        }

        public function get(string $endpoint)
        {
            try {
                $response = $this->client->get($endpoint);
                return json_decode($response->getBody(), true);
            } catch (GuzzleException $e) {
                throw new \Exception("Revolut API Error: {$e->getMessage()}");
            }
        }

        public function post(string $endpoint, array $data = [])
        {
            try {
                $response = $this->client->post($endpoint, [
                    'json' => $data,
                ]);
                return json_decode($response->getBody(), true);
            } catch (GuzzleException $e) {
                throw new \Exception("Revolut API Error: {$e->getMessage()}");
            }
        }
    }
