<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Revolut API Configuration
    |--------------------------------------------------------------------------
    |
    | Here you can configure your Revolut API settings.
    |
    */

    'api_key' => env('REVOLUT_API_KEY'),

    'api_base_url' => env('REVOLUT_API_URL', 'https://merchant.revolut.com/api/1.0'),

    'test_mode' => env('REVOLUT_TEST_MODE', false),

    'public_key' => env('REVOLUT_PUBLIC_KEY'),

    /*
    |--------------------------------------------------------------------------
    | Webhook Configuration
    |--------------------------------------------------------------------------
    |
    | Configure the webhook endpoint and secret for Revolut payment notifications.
    |
    */

    'webhook' => [
        'secret' => env('REVOLUT_WEBHOOK_SECRET'),
        'endpoint' => env('REVOLUT_WEBHOOK_ENDPOINT', '/api/revolut/webhook'),
    ],
];
