// Load Revolut SDK
(function() {
    console.log('Starting Revolut SDK loader...');
    
    const script = document.createElement('script');
    script.src = 'https://merchant.revolut.com/embed.js';
    script.async = true;
    
    // Function to check if SDK is ready
    function checkSDKReady() {
        console.log('Checking SDK readiness...', {
            RevolutCheckout: typeof window.RevolutCheckout
        });

        if (typeof window.RevolutCheckout === 'function') {
            console.log('SDK is ready, initializing payment integration');
            try {
                // Initialize the SDK
                window.RevolutCheckout().then(sdk => {
                    console.log('SDK initialized:', sdk);
                    window.RevolutCheckout = sdk;
                    
                    // SDK is ready, initialize our payment integration
                    if (typeof loadRevolutPayScript === 'function') {
                        loadRevolutPayScript();
                    } else {
                        console.error('loadRevolutPayScript function not found');
                    }
                }).catch(error => {
                    console.error('Failed to initialize SDK:', error);
                });
            } catch (error) {
                console.error('Failed to initialize SDK:', error);
            }
        } else {
            console.log('SDK not ready yet, checking again in 100ms');
            // SDK not ready yet, check again in 100ms
            setTimeout(checkSDKReady, 100);
        }
    }

    // Handle script load error
    script.onerror = function(error) {
        console.error('Failed to load Revolut SDK:', error);
    };

    // Start checking when script loads
    script.onload = function() {
        console.log('Revolut SDK script loaded, starting readiness check');
        checkSDKReady();
    };
    
    // Add script to document
    document.head.appendChild(script);
    console.log('Revolut SDK script tag added to document');
})(); 