<?php

namespace Mtcmedia\RevolutPaymentProvider\Classes;

use Basket;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\Log;
use Order;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\View;

class RevolutPay
{
    const PAYMENT_SESSIONS_URI = 'payment-sessions';

    public array $errors = [];
    private Basket $basket;
    private array $paymentSession;
    private $config;

    public function __construct(array $config)
    {
        $this->config = $config;
    }

    /**
     * Outputs a form of revolut payments
     */
    public function form($basket)
    {
        $twig = app('twig');
        // Get the total amount from the basket
        $amount = $basket->cost_total;
        $currency = $basket->currency;

        // Get the base URL
        $baseUrl = rtrim(config('app.url'), '/');

        // Prepare configuration for the template
        $config = [
            'public_key' => $this->config['public_key'],
            'test_mode' => $this->config['test_mode'] ?? true,
            'create_order_url' => $this->config["api_base_url"] . '/api/orders',
            'total' => $amount,
            'currency' => $currency["currency"] ?? 'GBP',
            'debug' => $this->config['debug'] ?? false
        ];


        return $twig->render('form.twig', [
            'config' => $config,
            'revolut_config' => $config,
            'order' => $basket,
            'basket' => $basket
        ]);
    }

    private function outputForm()
    {


        // Get configuration
        $revolut_config = [
            'public_key' => config('revolut.public_key'),
            'test_mode' => config('revolut.test_mode', false),
            'create_order_url' => '/api/revolut/create-order'
        ];

        // Get order data
        $order = [
            'currency' => $this->basket->currency["currency"] ?? 'EUR',
            'total_amount' => (int)($this->basket->cost_total * 100) // Convert to cents
        ];

        return $twig->render('revolut/form.twig', [
            'revolut_config' => $revolut_config,
            'order' => $order
        ]);
    }

}
