<?php

namespace Mtcmedia\RevolutPaymentProvider\Middleware;

use Closure;
use Illuminate\Http\Request;

class RevolutCorsMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);

        // Add CORS headers for Revolut API
        $response->headers->set('Access-Control-Allow-Origin', '*');
        $response->headers->set('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS');
        $response->headers->set('Access-Control-Allow-Headers', 'Content-Type, Authorization, X-Requested-With, X-CSRF-TOKEN');
        $response->headers->set('Access-Control-Allow-Credentials', 'true');

        return $response;
    }
} 