<?php

namespace Mtc\RevolutPaymentProvider\Classes;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class RevolutPayment extends Model
{
    protected $table = 'revolut_payments';

    protected $fillable = [
        'order_id',
        'user_id',
        'member_id',
        'member_email',
        'transaction_id',
        'status',
        'method',
        'amount',
        'currency',
        'token',
        'checkout_url',
        'raw_response'
    ];

    const STATUS_PENDING = 'pending';
    const STATUS_AUTHORIZED = 'authorized';
    const STATUS_AUTHENTICATED = 'authenticated';
    const STATUS_COMPLETED = 'completed';
    const STATUS_FAILED = 'failed';
    const STATUS_CANCELLED = 'cancelled';
    const STATUS_DECLINED = 'declined';
    const STATUS_PAID = 'paid';
    const STATUS_RESERVED = 'reserved';

    /**
     * Relationship to the Order model (if applicable).
     */
    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class);
    }

    /**
     * Relationship to the Member/User model (if applicable).
     */
    public function member(): BelongsTo
    {
        return $this->belongsTo(Member::class); // or User::class depending on your app
    }
}
