<?php
    namespace Mtc\RevolutPaymentProvider\Console\Commands;

    use Illuminate\Support\Facades\Route;
    use Illuminate\Support\Facades\Http;

    class CreateOrderWebhook extends \Illuminate\Console\Command
    {
        const CREATE_WEBHOOK_API_URL = "/api/1.0/webhooks";

        protected $signature = 'revolut:create-webhook';
        protected $description = 'Create a webhook for Revolut with selected event types.';

        public function handle()
        {
            $this->info('Revolut Webhook Creation');

            $choice = [
                "create",
                "get_all",
                "update",
                ];

            $selectedChoice = $this->choice(
                'Select a webhook endpoint to use',
                $choice,
                0
            );


            match($selectedChoice) {
                "create"=>$this->createEndpoint(),
                "get_all"=>$this->getAllEndpoints(),
                "update"=>$this->updateEndpoint(),
            };

        }

        public function getAllEndpoints()
        {
            $urlSend = rtrim(config('app.url'), '/').'revolut-api/'.self::CREATE_WEBHOOK_API_URL;
            $this->info("Getting all endpoints...");
        }

        public function updateEndpoint(){
            $this->info("Updating Endpoints");
        }

        public function createEndpoint()
        {
            $this->headers = [
                'Authorization'  => "Bearer ".config('revolut.api_key'),
                'Content-Type'  => 'application/json',
                'Revolut-Api-Version' => "2024-09-01"
            ];
            $this->baseUrl = config("revolut.api_url");


            // Step 1: Ask for input URL suffix
            $webhookRoutes = collect(Route::getRoutes())
                ->filter(function ($route) {
                    return str_contains($route->uri(), 'revolut/webhook/');
                })
                ->map(function ($route) {
                    return $route->uri();
                })
                ->values()
                ->all();

            if (empty($webhookRoutes)) {
                $this->error('No Revolut webhook routes found.');
                return;
            }

// Let user choose one
            $selectedUri = $this->choice(
                'Select a webhook endpoint to use',
                $webhookRoutes,
                0
            );

            $webhookUrl = rtrim(config('app.url'), '/') . '/' . ltrim($selectedUri, '/');
            $this->info("Selected webhook URL: $webhookUrl");



            // Define available event types
            $availableEvents = [
                'ORDER_AUTHORISED',
                'ORDER_COMPLETED',
                'ORDER_CANCELLED',
                'ORDER_PAYMENT_AUTHENTICATED',
                'ORDER_PAYMENT_DECLINED',
                'ORDER_PAYMENT_FAILED',
                'PAYOUT_INITIATED',
                'PAYOUT_COMPLETED',
                'PAYOUT_FAILED',
                'DISPUTE_ACTION_REQUIRED',
                'DISPUTE_UNDER_REVIEW',
                'DISPUTE_WON',
                'DISPUTE_LOST'

            ];
            $this->line('Select events to subscribe to (comma-separated numbers, default: 1)');
            foreach ($availableEvents as $key => $event) {
                $this->line(" [$key] $event");
            }

            $input = $this->ask('Enter event numbers', '1');

            $selectedKeys = array_map('trim', explode(',', $input));
            $selectedEvents = [];

            foreach ($selectedKeys as $key) {
                if (isset($availableEvents[$key])) {
                    $selectedEvents[] = $availableEvents[$key];
                }
            }

            if (empty($selectedEvents)) {
                $this->warn('No valid events selected. Aborting.');
                return;
            }

            // Confirm and proceed
            $this->info('Selected event(s):');
            foreach ($selectedEvents as $event) {
                $this->line("- $event");
            }


            $selectedEventsPayload = [];
            // Simulate webhook creation
            foreach ($selectedEvents as $event) {
                $this->line("Creating webhook for event: {$event}...");

                sleep(1);
            }

            $payload = [
                'url'=> $webhookUrl,
                'events'=> $selectedEvents,
            ];

            $this->info("Payload Data:  " . json_encode($payload,JSON_UNESCAPED_SLASHES));


            $urlSend = rtrim($this->baseUrl, '/').self::CREATE_WEBHOOK_API_URL;


            $this->info("Sending payload to url: {$urlSend}");
            $response = Http::withHeaders($this->headers)->withOptions([
                'allow_redirects' => false, // prevent GET fallback on 3xx
            ])->send('POST', $urlSend, [
                'body' => json_encode($payload),
            ])->throw()->collect()->toJson();


//            The HTTP::post does not work-->needs fixing
            /**
             * getting the following error
             * Payload Data:  {"url":"http://weightmedics.localdev/revolut/webhook/order","events":["ORDER_CANCELLED"]}
             *
             * In Response.php line 272:
             *
             * HTTP request returned status code 404:
             * [{"id":"4fc51767-b3a8-4a1b-80f4-39b5a1866851","url":"https:\/\/danandrei.weightmedics.mtcdevserver7.com\/revolut\/webhoo (trunc
             * ated...)
             */



            $this->info('Webhook(s) created successfully.'. $response);
        }
    }
