<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Payment Gateway keys
    |--------------------------------------------------------------------------
    |
    | Please set site specific keys in .env file
    | Production keys should never be part of tracked repo
    |
    */
    'vendor_name' => env('SAGEPAY_VENDOR', ''),
    'encryption_password' => env('SAGEPAY_ENCRYPTION', ''),

    /*
    |--------------------------------------------------------------------------
    | Gateway mode
    |--------------------------------------------------------------------------
    |
    | Whether to use staging or live endpoint
    |
    */
    'use_production_endpoint' => env('SAGEPAY_LIVE', false),

    /*
    |--------------------------------------------------------------------------
    | Payment gateway class
    |--------------------------------------------------------------------------
    |
    | The class that implements the Mtc\Checkout\Contracts\PaymentGateway
    |
    */
    'payment_gateway_class' => \Mtc\Sagepay\Sagepay::class,

    /*
    |--------------------------------------------------------------------------
    | Payment gateway verifier
    |--------------------------------------------------------------------------
    |
    | Class that allows you to set whether this order can be paid with this payment gateway
    |
    */
    'applicable_check_class' => \Mtc\Sagepay\SagepayApplicableCheck::class,

    /*
    |--------------------------------------------------------------------------
    | Whether to send email from SagePay
    |--------------------------------------------------------------------------
    |
    | Sagepay has capability to send email.
    | This is disabled by default
    |
    */

    'send_email' => false,
    'vendor_email' => '',
    'email_message' => 'Thank you for your purchase',

    /*
    |--------------------------------------------------------------------------
    | Successful payment
    |--------------------------------------------------------------------------
    |
    | Payment will be considered as successful if it has one of these statuses
    |
    */
    'successful_payment_statuses' => [
        'OK',
        'AUTHENTICATED',
        'REGISTERED'
    ]
];
