<?php

namespace Mtc\SalesTracking\Listeners;

use Mtc\Checkout\Events\PaymentSuccessPage;
use Mtc\Core\Seo\Setting;

/**
 * Class TrackInvoiceOnGoogle
 *
 * @package Mtc\SalesTracking
 */
class TrackInvoiceOnGoogle
{
    /**
     * Handle the event.
     *
     * @return array|void
     */
    public function handle(PaymentSuccessPage $event)
    {
        if ($event->first_time !== true) {
            return;
        }

        // Ensure tracking values are set up
        $gtm = Setting::query()->where('key', 'GTM_ID')->first()->value ?? null;
        $analytics = Setting::query()->where('key', 'GA_USERAGENT')->first()->value ?? null;
        if (empty($gtm) && empty($analytics)) {
            return;
        }

        $template = !empty($gtm) ? 'google_tag_manager_tracking.twig' : 'google_analytics_tracking.twig';
        return [
            'tracking' => template($template, [
                'order' => $event->invoice->getPayable(),
            ])
        ];
    }

}
