<?php

namespace Mtc\SalesTracking\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider;
use Mtc\Checkout\Events\PaymentSuccessPage;
use Mtc\SalesTracking\Listeners\TrackInvoiceOnGoogle;

/**
 * Class TrackingProvider
 *
 * @package Mtc\SalesTracking
 */
class TrackingProvider extends EventServiceProvider
{
    protected $listen = [
        PaymentSuccessPage::class => [
            TrackInvoiceOnGoogle::class,
        ]
    ];

    /**
     * Boot the provider
     */
    public function boot()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/sales_tracking.php', 'sales_tracking');
        parent::boot();
        app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');
    }

}
