<?php

namespace Mtc\ShippingManager\Http\Controllers\Admin;

use Illuminate\Support\Str;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Orders\Order;
use Mtc\Orders\OrderShipment;

/**
 * Class DownloadShipmentLabelController
 *
 * @package Mtc\ShippingManager
 */
class DownloadShipmentLabelController extends Controller
{
    public function __invoke(Order $order, OrderShipment $shipment)
    {
        if ($shipment->label_format === 'html') {
            return $shipment->label;
        }

        if (Str::upper($shipment->label_format) === 'PDF') {
            return response(base64_decode($shipment->label), 200, [
                'Content-type' => 'application/pdf',
            ]);
        }

        // TODO: image formats

    }
}
