<?php

use Illuminate\Routing\Router;

use Mtc\ShippingManager\Http\Controllers\Admin\DeliveryCourierController;
use Mtc\ShippingManager\Http\Controllers\Admin\CollectLocationController;
use Mtc\ShippingManager\Http\Controllers\Admin\DownloadShipmentLabelController;
use Mtc\ShippingManager\Http\Controllers\Admin\ExportShipmentController;
use Mtc\ShippingManager\Http\Controllers\Admin\ZoneController;
use Mtc\ShippingManager\Http\Controllers\Admin\RateController;
use Mtc\ShippingManager\Http\Controllers\DeliveryController;
use Mtc\ShippingManager\Http\Controllers\Admin\CollectionPointController;

// Admin routes
$router->group([
    'prefix' => '/admin',
    'as' => 'admin.',
    'middleware' => [
        'auth'
    ]
], function (Router $router) {

    $router->resource('/collection-points', CollectionPointController::class);

    $router->group([
        'prefix' => 'shipping-manager',
        'as' => 'shipping-manager.'
    ], function (Router $router) {
        $router->resource('/zones', ZoneController::class);
        $router->resource('/zones/{zone_id}/rates', config('shipping_manager.rate_controller'))
            ->only([
                'index',
                'create',
                'store'
            ]);
    });

    if (config('courier.enabled')) {
        $router->put('/orders/{order}/shipments/{shipment}/export', config('orders.shipment_export_controller'))->name('shipment.export');
        $router->any('/shipments/{shipment}/download-label', DownloadShipmentLabelController::class)->name('shipment.download-label');
    }
});

$router->get('/checkout/delivery', DeliveryController::class . '@show');
$router->post('/checkout/delivery', DeliveryController::class . '@update');
