<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Global enable toggle
    |--------------------------------------------------------------------------
    |
    | Disabling this will not bootstrap anything for the service
    |
    */

    'enabled' => true,

    /*
    |--------------------------------------------------------------------------
    | Shipping types
    |--------------------------------------------------------------------------
    |
    | Defines what shipping types are available on site.
    | Default options would be Deliver and Collection,
    | However custom versions like deliver to a drop point can be added here
    |
    */

    'shipping_types' => [
        'delivery' => [
            'enabled' => true,
            'class' => \Mtc\ShippingManager\DeliveryTypes\TableRateDelivery::class,
            'model' => \Mtc\ShippingManager\TableRate::class,
        ],
        'collection' => [
            'enabled' => true,
            'class' => \Mtc\ShippingManager\DeliveryTypes\CollectionDelivery::class,
            'model' => \Mtc\ShippingManager\CollectionPoint::class,
            'cost' => 0,
        ],
    ],

    'preemptive_shipping_calculation' => true,
    'preemptive_shipping_type' => 'delivery',

    /*
    |--------------------------------------------------------------------------
    | Service Providers
    |--------------------------------------------------------------------------
    |
    | Attach additional service providers for providing routing and event injection
    | Routing
    |
    */

    'service_providers' => [
        \Mtc\ShippingManager\Providers\ShippingEventServiceProvider::class,
        \Mtc\ShippingManager\Providers\ShippingRouteServiceProvider::class,
        \Mtc\ShippingManager\Providers\CourierServiceProvider::class,
    ],

    'delivery_method_response_class' => \Mtc\ShippingManager\Http\Resources\DeliveryMethodResponse::class,

    /*
    |--------------------------------------------------------------------------
    | Discount (Percentage)
    |--------------------------------------------------------------------------
    |
    | Discount configuration for shipping zone rates (Each rate can have one discount)
    |
    */
    'discount' => false,
    'discount_relation_name' => 'delivery-discount',
    'discount_class' => \Mtc\ShippingManager\Discount\Discount::class,
    'discount_type' => \Mtc\ShippingManager\Discount\Percentage::class,
    'discount_validation' => [
        'basket' => \Mtc\ShippingManager\Discount\DiscountableBasket::class,
        'item' => \Mtc\ShippingManager\Discount\DiscountableItem::class
    ],


    'couriers_enabled' => false,

    'courier_service_api_token' => env('COURIER_SERVICE_API_TOKEN', ''),

    'delivery_service_test_url' =>  env('COURIER_SERVICE_URL', 'http://delivery.mtcdevserver3.com/'),
    'delivery_service_url' =>  env('COURIER_SERVICE_URL', 'http://delivery.mtcdevserver3.com/'),

    'courier_export_status' => 4,

    'courier_service' => \Mtc\ShippingManager\Courier\CourierService::class,
    'order_map_to_courier' => \Mtc\ShippingManager\Courier\OrderMap::class,

];
