<?php
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateShippingZoneTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('shipping_zones', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->boolean('disabled')->default(0);
            $table->integer('parent_id')->default(0);
            $table->enum('type', ['country', 'postal'])->default('country');
            $table->text('postal_zones')->nullable();
            $table->timestamps();

            $table->index('name');
            $table->index('parent_id');
        });

        Schema::create('shipping_zone_table_rates', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('zone_id');
            $table->integer('delivery_courier_id')->nullable();
            $table->integer('delivery_service_id')->nullable();
            $table->string('name');
            $table->boolean('disabled')->default(0);
            $table->enum('rate_type', ['weight', 'price'])->default('weight');
            $table->float('range_min');
            $table->float('range_max');
            $table->float('rate');
            $table->text('modifiers')->nullable();
            $table->integer('order');
            $table->timestamps();

            $table->index('zone_id');
        });

        Schema::create('shipping_zone_countries', function (Blueprint $table) {
            $table->increments('id')->unsigned();
            $table->integer('country_id');
            $table->integer('zone_id');

            $table->index('country_id');
            $table->index('zone_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('shipping_zones');
        Schema::dropIfExists('shipping_zone_table_rates');
        Schema::dropIfExists('shipping_zone_countries');
    }
}
