<?php

namespace Mtc\ShippingManager;

use Illuminate\Support\Facades\Auth;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\ShippingManager\Contracts\ShippingModifier;

/**
 * Class PalletItemModifier
 *
 * Modifier that checks if order is made by a wholesale member
 */
class AdminUserShippingModifier implements ShippingModifier
{
    /**
     * Retrieve the name
     *
     * @return string
     */
    public function getName()
    {
        return 'Admin User Restricted';
    }

    /**
     * Check whether the modifier is applicable to the rate
     *
     * @return bool
     */
    public function isApplicable(BasketRepositoryInterface $basket_repository, TableRate $rate)
    {
        return Auth::guest() === false;
    }

    /**
     * Define whether this modifier MUST be matched for this rate to work
     *
     * @return bool
     */
    public function isMandatoryOnRate(): bool
    {
        return false;
    }

    /**
     * Define whether this modifier matching will discard other rates
     *
     * @return bool
     */
    public function willDiscardOtherRates(): bool
    {
        return false;
    }

    /**
     * Define whether this modifier matching will ignore the discard of other methods
     *
     * @return bool
     */
    public function isGloballyAvailable(): bool
    {
        return true;
    }
}
