<?php

namespace Mtc\ShippingManager\Discount;

use Mtc\Basket\Contracts\BasketContract;
use Mtc\ShippingManager\Discount\Discount;

/**
 * Class DiscountableItem
 * @package Mtc\ShippingManager\Discount
 */
class DiscountableItem
{
    /**
     * @param Discount $rate
     * @param $item
     * @return bool
     */
    public function validate(Discount $rate_discount, $item)
    {
        //Check sale price < price (Item have discount)
        if ($item->purchasable->sale_price && $item->purchasable->sale_price < $item->purchasable->price) {
            return false;
        }

        return true;
    }
}
