<?php

namespace Mtc\ShippingManager\Http\Controllers;

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Event;
use Mtc\Basket\Contracts\BasketContract;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\ShippingManager\Facades\DeliveryMethod;
use Mtc\ShippingManager\Events\SetDeliveryForBasket;
use Mtc\ShippingManager\Http\Requests\SetDeliveryMethodRequest;

/**
 * Class DeliveryController
 *
 * @package Mtc\ShippingManager
 */
class DeliveryController extends Controller
{
    /**
     * Show all applicable methods
     *
     * @param BasketContract $basket
     * @return mixed
     */
    public function show(BasketRepositoryInterface $basket)
    {
        return [
            'methods' => DeliveryMethod::methodsForBasket($basket),
            'basket' => App::make(config('basket.checkout_ajax_response_class')),
        ];
    }

    /**
     * Set delivery for basket
     *
     * @param SetDeliveryMethodRequest $request
     * @param BasketContract $basket
     * @return mixed
     */
    public function update(SetDeliveryMethodRequest $request, BasketRepositoryInterface $basket)
    {
        $basket->updateSurchargeByType($request->input('type', 'delivery'), $request->input('method_id'));
        Event::dispatch(new SetDeliveryForBasket($request, $basket));

        return App::make(config('basket.checkout_ajax_response_class'));
    }
}
