<?php

namespace Mtc\ShippingManager\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Mtc\Foundation\Rules\ValidPostcode;

/**
 * Class CreateCollectionPointRequest
 *
 * @package Mtc\ShippingManager\Http\Requests
 */
class CollectionPointRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required',
            'address1' => 'required',
            'address2' => 'present',
            'city' => 'required',
            'county' => config('foundation.country_list_value_fields.states') ? 'required' : 'max:100',
            'country' => 'required|exists:countries,code',
            'postcode' => new ValidPostcode($this->request->get('country', 'GB')),
        ];
    }

    /**
     * Get custom messages for validator errors.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'bane.required' => 'The Location Name field is required.',
            'first_name.required' => 'The First Name field is required.',
            'last_name.required' => 'The Last Name field is required.',
            'address1.required' => 'The Address 1 field is required.',
            'city.required' => 'The City field is required.',
            'county.required' => 'The County field is required.',
            'country.required' => 'The Country field is required.',
        ];
    }
}
