<?php

namespace Mtc\ShippingManager\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\App;
use Mtc\Foundation\Rules\ValidPostcode;

class SetDeliveryMethodRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $type = $this->request->get('type', 'delivery');
        $table = App::make(config("shipping_manager.shipping_types.{$type}.model"))->getTable();
        return [
            'method_id' => "required|numeric|exists:{$table},id",
        ];
    }
}
