<?php

namespace Mtc\ShippingManager\Listeners;

use Mtc\ShippingManager\TableRate;
use Mtc\Shop\Events\NewOrderEvent;

/**
 * Class UpdateOrderShipmentInfo
 *
 * Update order with delivery method information
 *
 * @package Mtc\ShippingManager
 */
class UpdateOrderShipmentInfo
{
    /**
     * Set the delivery name for order when creating it
     *
     * @param NewOrderEvent $event
     */
    public static function handle(NewOrderEvent $event)
    {
        $basket = $event->getBasket();
        $order = $event->getOrder();
        $shipping_rate = TableRate::query()->find($basket->delivery_selected);

        if ($shipping_rate) {
            $order->delivery_name = $shipping_rate->name;
            $order->save();
        }
    }
}
