Vue.component('shipping-manager', require('./shipping_manager').default);

$(document).ready(function () {

    if ($('.js_overlayShipping').length) {
        $('.js_overlayShipping').mtcOverlay({
            max_width: 640,
        });
    }

    $('.clearCountries').click(function () {
        $('#countries_list option:selected').removeAttr('selected');
        $('#countries_list').trigger('chosen:updated');
    });

    $('.showAllCountries').click(function () {
        $('#countries_list option').prop('selected', true);
        $('#countries_list').trigger('chosen:updated');
    });

    $('.addSpecifiedCountries').click(function () {
        var selected_countries = $("#countries_list").val();
        if (!selected_countries) {
            selected_countries = [];
        }
        var countries = this.getAttribute("data-countries");
        countries = countries.split(',');

        var merged_countries = $.merge(selected_countries, countries );

        $("#countries_list").val(merged_countries).trigger("chosen:updated");
    });
});
