<?php

namespace Mtc\ShippingManager\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\ShippingManager\Facades\ShippingModifiers;
use Mtc\ShippingManager\Zone;
use Mtc\ShippingManager\TableRate;

/**
 * Class RateController
 * @package Mtc\Plugins\ShippingManager\Classes\Http\Controllers\Admin
 */
class RateController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @param $zone_id
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    public function index($zone_id)
    {
        $shipping_zone = Zone::find($zone_id);
        $this->page_meta['page_name'] = 'Shipping Zone Rates';

        return template('ShippingManager/admin/zones/rates/index.twig', [
            'page_meta' => $this->page_meta,
            'shipping_zone' => $shipping_zone,
            'selected_tab_nav' => 'rates',
            'rate_types' => TableRate::$rate_types,
            'rate_modifiers' => ShippingModifiers::getAllModifiers(),
        ]);
    }

    /**
     * Create a new rate
     *
     * @param Request $request
     * @param $zone_id
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function create($zone_id)
    {
        $zone_rate = TableRate::query()
            ->create([
                'zone_id' => $zone_id,
                'name' => '',
                'rate_type' => 'price',
                'range_min' => 0,
                'range_max' => 999999,
                'rate' => 0,
                'delivery_courier_id' => 0,
                'delivery_service_id' => 0,
                'disabled' => 1
            ]);

        session()->flash('messages', [
            'type' => 'success',
            'content' => 'Rates Added'
        ]);

        return redirect(route('admin.shipping-manager.rates.index', [$zone_id]));
    }

    /**
     * Bulk update rates in a zone
     *
     * @param Request $request
     * @param $zone_id
     */
    public function store(Request $request, $zone_id)
    {
        $zone = Zone::query()->find($zone_id);
        $zone->rates
            ->each(function (TableRate $rate) use ($request) {
                if ($request->has("rate.{$rate->id}.remove")) {
                    $rate->delete();
                    return;
                }
                $rate->fill($request->input("rate.{$rate->id}"));
                $rate->disabled = $request->input("rate.{$rate->id}.active") ? 0 : 1;
                $rate->save();
            });

        session()->flash('messages', [
            'type' => 'success',
            'content' => 'Rates updated'
        ]);
        return redirect()->back();
    }
}
