<?php

namespace Mtc\ShippingManager\Discount;

use Illuminate\Database\Eloquent\Model;
use Mtc\Money\Price;

/**
 * Class Percentage
 * @package Mtc\ShippingManager
 */
class Percentage
{
    /**
     * Apply Percentage Discount to Basket
     *
     * @param Model $rate_discount
     * @param $basket
     */
    public function apply(Model $rate_discount, $basket)
    {
        $total_discounted_price = $basket->items->filter(function ($item) use ($rate_discount) {
            return $rate_discount->availableForItem($item);
        })->map(function ($item) use ($rate_discount) {
            $item->discount_price = $this->applyToItem($rate_discount, $item);
            return $item;
        })->sum('discount_price');

        $rate_discount->discounted_amount = $total_discounted_price;
    }

    /**
     * @param Model $rate_discount
     * @param $item
     * @return float|int
     */
    public function applyToItem(Model $rate_discount, $item) {
        return $item->line_total / 100 * $rate_discount->discount;
    }
}
